/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackItemScreenHandler;
import com.tiviacz.travelersbackpack.util.InventoryUtils;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackInventory
implements ITravelersBackpackInventory {
    private InventoryImproved inventory = this.createInventory(45);
    private InventoryImproved craftingInventory = this.createInventory(9);
    public SingleVariantStorage<FluidVariant> leftTank = this.createFluidTank(TravelersBackpackConfig.tanksCapacity);
    public SingleVariantStorage<FluidVariant> rightTank = this.createFluidTank(TravelersBackpackConfig.tanksCapacity);
    private final class_1657 player;
    private final class_1799 stack;
    private int lastTime;
    private final byte screenID;
    private final String INVENTORY = "Inventory";
    private final String CRAFTING_INVENTORY = "CraftingInventory";
    private final String LEFT_TANK = "LeftTank";
    private final String LEFT_TANK_AMOUNT = "LeftTankAmount";
    private final String RIGHT_TANK = "RightTank";
    private final String RIGHT_TANK_AMOUNT = "RightTankAmount";
    private final String LAST_TIME = "LastTime";
    private final String COLOR = "Color";

    public TravelersBackpackInventory(class_1799 stack, class_1657 player, byte screenID) {
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        this.readAllData(this.getTagCompound(stack));
    }

    @Override
    public void writeItems(class_2487 compound) {
        InventoryUtils.writeNbt(compound, this.inventory.getStacks(), true, false);
        InventoryUtils.writeNbt(compound, this.craftingInventory.getStacks(), true, true);
    }

    @Override
    public void readItems(class_2487 compound) {
        this.inventory = this.createInventory(45);
        this.craftingInventory = this.createInventory(9);
        InventoryUtils.readNbt(compound, this.inventory.getStacks(), false);
        InventoryUtils.readNbt(compound, this.craftingInventory.getStacks(), true);
    }

    @Override
    public void writeTanks(class_2487 compound) {
        compound.method_10566("LeftTank", (class_2520)((FluidVariant)this.getLeftTank().variant).toNbt());
        compound.method_10566("RightTank", (class_2520)((FluidVariant)this.getRightTank().variant).toNbt());
        compound.method_10544("LeftTankAmount", this.getLeftTank().amount);
        compound.method_10544("RightTankAmount", this.getRightTank().amount);
    }

    @Override
    public void readTanks(class_2487 compound) {
        this.leftTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("LeftTank"));
        this.rightTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("RightTank"));
        this.leftTank.amount = compound.method_10537("LeftTankAmount");
        this.rightTank.amount = compound.method_10537("RightTankAmount");
    }

    @Override
    public void writeColor(class_2487 compound) {
    }

    @Override
    public void readColor(class_2487 compound) {
    }

    @Override
    public void writeTime(class_2487 compound) {
    }

    @Override
    public void readTime(class_2487 compound) {
    }

    @Override
    public void writeAllData(class_2487 compound) {
        this.writeItems(compound);
        this.markTankDirty();
    }

    @Override
    public void readAllData(class_2487 compound) {
        this.readItems(compound);
        this.readTanks(compound);
    }

    @Override
    public SingleVariantStorage<FluidVariant> getLeftTank() {
        return this.leftTank;
    }

    @Override
    public SingleVariantStorage<FluidVariant> getRightTank() {
        return this.rightTank;
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 41, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 43, this.player);
    }

    @Override
    public void markTankDirty() {
        this.writeTanks(this.getTagCompound(this.stack));
        this.sendPackets();
    }

    public void sendPackets() {
        if (this.screenID == 2) {
            ComponentUtils.sync(this.player);
            ComponentUtils.syncToTracking(this.player);
        }
    }

    @Override
    public boolean hasColor() {
        return this.getTagCompound(this.stack).method_10545("Color");
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return this.getTagCompound(this.stack).method_10550("Color");
        }
        return 0;
    }

    @Override
    public boolean hasTileEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public InventoryImproved getInventory() {
        return this.inventory;
    }

    @Override
    public InventoryImproved getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public class_1799 decrStackSize(int index, int count) {
        class_1799 itemstack = class_1262.method_5430(this.inventory.getStacks(), (int)index, (int)count);
        if (!itemstack.method_7960()) {
            this.method_5431();
        }
        return itemstack;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public class_1937 getWorld() {
        return this.player.field_6002;
    }

    @Override
    public class_2338 getPosition() {
        return this.player.method_24515();
    }

    @Override
    public class_1799 getItemStack() {
        return this.stack;
    }

    @Override
    public class_2487 getTagCompound(class_1799 stack) {
        if (stack.method_7969() == null) {
            class_2487 tag = new class_2487();
            stack.method_7980(tag);
        }
        return stack.method_7969();
    }

    @Override
    public void method_5431() {
        this.writeAllData(this.getTagCompound(this.stack));
    }

    public static void openGUI(class_1657 player, final class_1799 stack, final byte screenID) {
        if (!player.field_6002.field_9236) {
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    buf.writeByte((int)screenID);
                }

                public class_2561 method_5476() {
                    return new class_2588("screen.travelersbackpack.item");
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new TravelersBackpackItemScreenHandler(syncId, inv, new TravelersBackpackInventory(stack, player, screenID));
                }
            });
        }
    }

    public InventoryImproved createInventory(int size) {
        return new InventoryImproved(class_2371.method_10213((int)size, (Object)class_1799.field_8037)){

            @Override
            public void method_5431() {
                TravelersBackpackInventory.this.writeItems(TravelersBackpackInventory.this.getTagCompound(TravelersBackpackInventory.this.stack));
            }
        };
    }

    public SingleVariantStorage<FluidVariant> createFluidTank(final long capacity) {
        return new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return capacity;
            }

            protected void onFinalCommit() {
                TravelersBackpackInventory.this.markTankDirty();
            }
        };
    }
}

